<?php

namespace App\Policies;

use App\Models\Experience;
use App\Models\User;

class ExperiencePolicy
{
    public function viewAny(User $user, $student_id)
    {
        // Student can view their own experiences, others might be allowed too (recruiters, etc.)
        return $user->isStudent() && $user->id === $student_id;
    }

    public function view(User $user, Experience $experience)
    {
        // Any authenticated user can view
        return true;
    }

    public function create(User $user, $student_id)
    {
        // Only the student themselves can create for their profile
        return $user->isStudent() && $user->id === $student_id;
    }

    public function update(User $user, Experience $experience)
    {
        // Only the owner student can update
        return $user->isStudent() && $user->id === $experience->student_id;
    }

    public function delete(User $user, Experience $experience)
    {
        // Only the owner student can delete
        return $user->isStudent() && $user->id === $experience->student_id;
    }
} 