<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class AddFieldsToRecruitersTable extends Migration
{
    public function up()
    {
        DB::statement("ALTER TABLE recruiters ADD COLUMN email VARCHAR(255);");
        DB::statement("ALTER TABLE recruiters ADD COLUMN phone VARCHAR(50);");
        DB::statement("ALTER TABLE recruiters ADD COLUMN linkedin VARCHAR(512);");
        DB::statement("ALTER TABLE recruiters ADD COLUMN summary TEXT;");
    }

    public function down()
    {
        // best-effort drop (may fail on some DBs if column doesn't exist)
        Schema::table('recruiters', function (Blueprint $table) {
            if (Schema::hasColumn('recruiters', 'email')) $table->dropColumn('email');
            if (Schema::hasColumn('recruiters', 'phone')) $table->dropColumn('phone');
            if (Schema::hasColumn('recruiters', 'linkedin')) $table->dropColumn('linkedin');
            if (Schema::hasColumn('recruiters', 'summary')) $table->dropColumn('summary');
        });
    }
}
