<?php

namespace Database\Seeders;

use App\Models\SkillNormalization;
use Illuminate\Database\Seeder;

class SkillNormalizationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $skills = [
            // Frontend Technologies
            [
                'canonical_name' => 'JavaScript',
                'aliases' => ['js', 'javascript', 'java script', 'es6', 'es2015', 'es7', 'es8', 'es2016', 'ecmascript'],
                'category' => 'Language',
            ],
            [
                'canonical_name' => 'TypeScript',
                'aliases' => ['typescript', 'ts', 'tsx'],
                'category' => 'Language',
            ],
            [
                'canonical_name' => 'React',
                'aliases' => ['react', 'reactjs', 'react.js', 'react native'],
                'category' => 'Framework',
            ],
            [
                'canonical_name' => 'Vue.js',
                'aliases' => ['vue', 'vuejs', 'vue.js', 'vue 3', 'vue2', 'vue 2'],
                'category' => 'Framework',
            ],
            [
                'canonical_name' => 'Angular',
                'aliases' => ['angular', 'angularjs', 'angular.js', 'angular 14', 'angular 15', 'angular 16', 'ng'],
                'category' => 'Framework',
            ],
            [
                'canonical_name' => 'Svelte',
                'aliases' => ['svelte', 'sveltekit'],
                'category' => 'Framework',
            ],
            [
                'canonical_name' => 'HTML/CSS',
                'aliases' => ['html', 'css', 'html/css', 'html5', 'css3', 'front end', 'frontend', 'html + css'],
                'category' => 'Language',
            ],
            [
                'canonical_name' => 'Tailwind CSS',
                'aliases' => ['tailwind', 'tailwind css', 'tailwindcss', 'tw'],
                'category' => 'Framework',
            ],
            [
                'canonical_name' => 'Bootstrap',
                'aliases' => ['bootstrap', 'bootstrap 5', 'bootstrap 4'],
                'category' => 'Framework',
            ],
            [
                'canonical_name' => 'Webpack',
                'aliases' => ['webpack', 'webpack 5'],
                'category' => 'Tool',
            ],
            [
                'canonical_name' => 'Vite',
                'aliases' => ['vite', 'vitejs'],
                'category' => 'Tool',
            ],

            // Backend Technologies
            [
                'canonical_name' => 'Node.js',
                'aliases' => ['node', 'nodejs', 'node.js', 'node js'],
                'category' => 'Runtime',
            ],
            [
                'canonical_name' => 'Express.js',
                'aliases' => ['express', 'expressjs', 'express.js', 'expressnode'],
                'category' => 'Framework',
            ],
            [
                'canonical_name' => 'Python',
                'aliases' => ['python', 'py', 'python 3', 'python3'],
                'category' => 'Language',
            ],
            [
                'canonical_name' => 'Django',
                'aliases' => ['django', 'djangorestframework', 'drf'],
                'category' => 'Framework',
            ],
            [
                'canonical_name' => 'Flask',
                'aliases' => ['flask', 'flask restful', 'flask rest'],
                'category' => 'Framework',
            ],
            [
                'canonical_name' => 'Java',
                'aliases' => ['java', 'j2ee', 'jvm'],
                'category' => 'Language',
            ],
            [
                'canonical_name' => 'Spring Boot',
                'aliases' => ['spring', 'spring boot', 'springboot', 'spring framework'],
                'category' => 'Framework',
            ],
            [
                'canonical_name' => 'C#',
                'aliases' => ['c#', 'csharp', 'c sharp'],
                'category' => 'Language',
            ],
            [
                'canonical_name' => '.NET',
                'aliases' => ['.net', 'dotnet', 'asp.net', 'asp.net core', '.net core'],
                'category' => 'Framework',
            ],
            [
                'canonical_name' => 'PHP',
                'aliases' => ['php', 'php 7', 'php 8', 'php 5'],
                'category' => 'Language',
            ],
            [
                'canonical_name' => 'Laravel',
                'aliases' => ['laravel', 'laravel 9', 'laravel 10', 'laravel 11'],
                'category' => 'Framework',
            ],
            [
                'canonical_name' => 'Go',
                'aliases' => ['go', 'golang', 'go lang'],
                'category' => 'Language',
            ],
            [
                'canonical_name' => 'Rust',
                'aliases' => ['rust', 'rustlang'],
                'category' => 'Language',
            ],

            // Databases
            [
                'canonical_name' => 'SQL',
                'aliases' => ['sql', 'mysql', 'postgres', 'postgresql', 'postgres sql', 'oracle sql', 'mariadb', 'sql server', 'sqldatabase'],
                'category' => 'Database',
            ],
            [
                'canonical_name' => 'MongoDB',
                'aliases' => ['mongodb', 'mongo', 'nosql'],
                'category' => 'Database',
            ],
            [
                'canonical_name' => 'Redis',
                'aliases' => ['redis', 'cache', 'caching'],
                'category' => 'Database',
            ],
            [
                'canonical_name' => 'Firebase',
                'aliases' => ['firebase', 'firestore', 'realtime database', 'google firebase'],
                'category' => 'Database',
            ],

            // AI/ML/Data
            [
                'canonical_name' => 'Machine Learning',
                'aliases' => ['ml', 'machine learning', 'supervised learning', 'unsupervised learning', 'classification', 'regression'],
                'category' => 'Skill',
            ],
            [
                'canonical_name' => 'Deep Learning',
                'aliases' => ['dl', 'deep learning', 'neural networks', 'cnn', 'rnn', 'lstm', 'transformers'],
                'category' => 'Skill',
            ],
            [
                'canonical_name' => 'TensorFlow',
                'aliases' => ['tensorflow', 'tf', 'tensorflow js'],
                'category' => 'Tool',
            ],
            [
                'canonical_name' => 'PyTorch',
                'aliases' => ['pytorch', 'torch'],
                'category' => 'Tool',
            ],
            [
                'canonical_name' => 'Scikit-learn',
                'aliases' => ['scikit-learn', 'sklearn'],
                'category' => 'Tool',
            ],
            [
                'canonical_name' => 'Data Analysis',
                'aliases' => ['data analysis', 'statistical analysis', 'statistics', 'pandas', 'numpy'],
                'category' => 'Skill',
            ],
            [
                'canonical_name' => 'Data Visualization',
                'aliases' => ['data visualization', 'tableau', 'power bi', 'matplotlib', 'seaborn', 'plotly'],
                'category' => 'Skill',
            ],

            // DevOps/Cloud
            [
                'canonical_name' => 'AWS',
                'aliases' => ['aws', 'amazon web services', 'amazon aws', 'amazon', 'ec2', 's3'],
                'category' => 'Cloud',
            ],
            [
                'canonical_name' => 'Google Cloud',
                'aliases' => ['gcp', 'google cloud', 'google cloud platform'],
                'category' => 'Cloud',
            ],
            [
                'canonical_name' => 'Azure',
                'aliases' => ['azure', 'microsoft azure'],
                'category' => 'Cloud',
            ],
            [
                'canonical_name' => 'Docker',
                'aliases' => ['docker', 'containers', 'containerization', 'docker compose'],
                'category' => 'Tool',
            ],
            [
                'canonical_name' => 'Kubernetes',
                'aliases' => ['kubernetes', 'k8s', 'k8'],
                'category' => 'Tool',
            ],
            [
                'canonical_name' => 'CI/CD',
                'aliases' => ['ci/cd', 'continuous integration', 'continuous deployment', 'jenkins', 'github actions', 'gitlab ci', 'circleci'],
                'category' => 'Tool',
            ],

            // Tools & Version Control
            [
                'canonical_name' => 'Git',
                'aliases' => ['git', 'version control', 'github', 'gitlab', 'bitbucket', 'gitflow'],
                'category' => 'Tool',
            ],
            [
                'canonical_name' => 'Linux',
                'aliases' => ['linux', 'ubuntu', 'centos', 'debian', 'bash', 'shell'],
                'category' => 'OS',
            ],

            // API & Web Services
            [
                'canonical_name' => 'REST API',
                'aliases' => ['rest', 'rest api', 'restful', 'api design', 'rest architecture'],
                'category' => 'Skill',
            ],
            [
                'canonical_name' => 'GraphQL',
                'aliases' => ['graphql', 'gql', 'apollo'],
                'category' => 'Tool',
            ],

            // Computer Science Fundamentals
            [
                'canonical_name' => 'Algorithms & Data Structures',
                'aliases' => ['problem solving', 'algorithms', 'dsa', 'data structures', 'algorithm design', 'problem solving'],
                'category' => 'Skill',
            ],

            // Soft Skills
            [
                'canonical_name' => 'Communication',
                'aliases' => ['communication', 'soft skills', 'team work', 'collaboration', 'teamwork', 'interpersonal'],
                'category' => 'Soft Skill',
            ],
            [
                'canonical_name' => 'Leadership',
                'aliases' => ['leadership', 'team lead', 'management', 'mentoring', 'delegation'],
                'category' => 'Soft Skill',
            ],
            [
                'canonical_name' => 'Project Management',
                'aliases' => ['project management', 'agile', 'scrum', 'kanban', 'planning', 'organization'],
                'category' => 'Soft Skill',
            ],
            [
                'canonical_name' => 'Web Development',
                'aliases' => ['web dev', 'web development', 'web developer', 'fullstack', 'full stack', 'full-stack', 'webdev'],
                'category' => 'Skill',
            ],
        ];

        foreach ($skills as $skill) {
            SkillNormalization::updateOrCreate(
                ['canonical_name' => $skill['canonical_name']],
                $skill
            );
        }
    }
}
