import sys
import fitz  # PyMuPDF

if len(sys.argv) < 2:
    print("Usage: python extract_cv_text.py <pdf_path>")
    sys.exit(1)

pdf_path = sys.argv[1]
text = ""

try:
    with fitz.open(pdf_path) as doc:
        for page in doc:
            text += page.get_text()
    # Print as UTF-8 to avoid encoding errors
    sys.stdout.buffer.write(text.encode('utf-8'))
except Exception as e:
    print(f"Error: {e}", file=sys.stderr)
    sys.exit(1) 