<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f4f4f4; }
        .login-container { max-width: 400px; margin: 60px auto; background: #fff; border-radius: 8px; box-shadow: 0 2px 8px #ccc; padding: 2rem; }
        h2 { text-align: center; color: #7b61ff; }
        label { display: block; margin-top: 1rem; }
        input[type="email"], input[type="password"] { width: 100%; padding: 8px; margin-top: 4px; border-radius: 4px; border: 1px solid #ccc; }
        button { margin-top: 1.5rem; width: 100%; background: #7b61ff; color: #fff; border: none; padding: 10px; border-radius: 4px; font-size: 16px; cursor: pointer; }
        .error { color: #c00; margin-top: 1rem; text-align: center; }
    </style>
</head>
<body>
    <div class="login-container">
        <h2>Recruiter Login</h2>
        <form method="POST" action="/login">
            @csrf
            <label for="email">Email</label>
            <input type="email" id="email" name="email" required autofocus>
            <label for="password">Password</label>
            <input type="password" id="password" name="password" required>
            <button type="submit">Login</button>
        </form>
        @if(session('error'))
            <div class="error">{{ session('error') }}</div>
        @endif
    </div>
</body>
</html> 