<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Public Authentication Routes
Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);
Route::get('/check-email-exists', [AuthController::class, 'checkEmailExists']);

// Protected Authentication Routes
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::get('/user', [AuthController::class, 'user']);
    Route::put('/profile', [AuthController::class, 'updateProfile']);
    Route::post('/profile/photo', [AuthController::class, 'uploadPhoto']);
    Route::get('/shortlist', [App\Http\Controllers\ShortlistController::class, 'index']);
    Route::put('/shortlist/{student_id}', [App\Http\Controllers\ShortlistController::class, 'updateNote']);
    Route::post('/shortlist', [App\Http\Controllers\ShortlistController::class, 'store']);
    Route::delete('/shortlist/{student_id}', [App\Http\Controllers\ShortlistController::class, 'destroy']);
    Route::get('/shortlist/export/csv', [App\Http\Controllers\ShortlistController::class, 'exportCsv']);
    Route::get('/shortlist/export/pdf', [App\Http\Controllers\ShortlistController::class, 'exportPdf']);
    Route::get('/p/{uuid}', [App\Http\Controllers\PublicProfileController::class, 'apiShow']);
    Route::get('/activity-logs', [App\Http\Controllers\AuthController::class, 'recentActivityLogs']);
    Route::get('/dashboard-stats', [App\Http\Controllers\AuthController::class, 'dashboardStats']);
    Route::get('/student/pro-tips', [App\Http\Controllers\AiTipsController::class, 'studentTips']);
    Route::post('/log-qr-scan', [App\Http\Controllers\AuthController::class, 'logQRScan']);
    Route::patch('/card-activation', [App\Http\Controllers\AuthController::class, 'setCardActivation']);
    Route::get('/students/{student_id}/experiences', [\App\Http\Controllers\ExperienceController::class, 'index']);
    Route::post('/students/{student_id}/experiences', [\App\Http\Controllers\ExperienceController::class, 'store']);
    Route::post('/students/{student_id}/experiences/batch', [\App\Http\Controllers\ExperienceController::class, 'storeBatch']);
    Route::get('/experiences/{id}', [\App\Http\Controllers\ExperienceController::class, 'show']);
    Route::put('/experiences/{id}', [\App\Http\Controllers\ExperienceController::class, 'update']);
    Route::delete('/experiences/{id}', [\App\Http\Controllers\ExperienceController::class, 'destroy']);
    Route::get('/students/{student_id}/educations', [\App\Http\Controllers\EducationController::class, 'index']);
    Route::post('/students/{student_id}/educations', [\App\Http\Controllers\EducationController::class, 'store']);
    Route::post('/students/{student_id}/educations/batch', [\App\Http\Controllers\EducationController::class, 'storeBatch']);
    Route::get('/educations/{id}', [\App\Http\Controllers\EducationController::class, 'show']);
    Route::put('/educations/{id}', [\App\Http\Controllers\EducationController::class, 'update']);
    Route::delete('/educations/{id}', [\App\Http\Controllers\EducationController::class, 'destroy']);
    Route::get('/students/{student_id}/skills', [\App\Http\Controllers\SkillController::class, 'index']);
    Route::post('/students/{student_id}/skills', [\App\Http\Controllers\SkillController::class, 'store']);
    Route::post('/students/{student_id}/skills/batch', [\App\Http\Controllers\SkillController::class, 'storeBatch']);
    Route::get('/skills/{id}', [\App\Http\Controllers\SkillController::class, 'show']);
    Route::put('/skills/{id}', [\App\Http\Controllers\SkillController::class, 'update']);
    Route::delete('/skills/{id}', [\App\Http\Controllers\SkillController::class, 'destroy']);
    
    // Smart Search Routes
    Route::post('/students/smart-search', [\App\Http\Controllers\SmartSearchController::class, 'search']);
    Route::get('/students/search-suggestions', [\App\Http\Controllers\SmartSearchController::class, 'suggestions']);
});

// Public CV Analysis Route
Route::post('/cv/analyze', [App\Http\Controllers\CvAnalysisController::class, 'analyze']);

// Public File Serving Route (for profile photos via symlink or fallback)
Route::get('/storage/{path}', function ($path) {
    $fullPath = storage_path('app/public/' . $path);
    
    if (!file_exists($fullPath)) {
        abort(404, 'File not found');
    }
    
    return response()->file($fullPath);
})->where('path', '.*');

// Legacy route for compatibility
// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });
