<?php

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

// Test Groq API
$apiKey = env('GROQ_API_KEY');
echo "Testing Groq API with key: " . substr($apiKey, 0, 10) . "...\n";

$response = Http::withOptions(['verify' => false])->withHeaders([
    'Content-Type' => 'application/json',
    'Authorization' => 'Bearer ' . $apiKey,
])->post('https://api.groq.com/openai/v1/chat/completions', [
    'messages' => [
        [
            'role' => 'user',
            'content' => 'Hello, please respond with a simple JSON object: {"test": "success"}'
        ]
    ],
    'model' => 'llama-3.3-70b-versatile',
    'stream' => false,
    'temperature' => 0
]);

echo "Response Status: " . $response->status() . "\n";
echo "Response Body: " . $response->body() . "\n";

if ($response->successful()) {
    $json = $response->json();
    if (isset($json['choices'][0]['message']['content'])) {
        echo "AI Response: " . $json['choices'][0]['message']['content'] . "\n";
    }
} else {
    echo "API call failed\n";
}
