<?php

require 'vendor/autoload.php';

$app = require 'bootstrap/app.php';

// Test database connection
try {
    $skill = \App\Models\SkillNormalization::first();
    echo "✅ Skills loaded from database\n";
    echo "Canonical Name: " . $skill->canonical_name . "\n";
    echo "Aliases: " . implode(', ', $skill->aliases ?? []) . "\n";
    echo "Category: " . ($skill->category ?? 'N/A') . "\n\n";
    
    // Count total skills
    $count = \App\Models\SkillNormalization::count();
    echo "Total Skills in Database: " . $count . "\n\n";
    
    // Sample some skills
    echo "Sample Skills:\n";
    $skills = \App\Models\SkillNormalization::take(5)->get();
    foreach ($skills as $skill) {
        echo "  - {$skill->canonical_name}: " . implode(', ', $skill->aliases ?? []) . "\n";
    }
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
